'use strict';

function BCPBankOffersModalCtrl($scope, $rootScope, BanksList){
    var elementId = "#modal-bank_service_options";

    $scope.modal = false;
    $scope.bankServices = [];
    $scope.accountBalance = 0;
    $scope.credits;
    $scope.investments;
    $scope.avaibleBankServices = [];
    $scope.disableButton;


    $scope.$on('Bank:openBankOffersModal', function(event, params){
        $scope.avaibleBankServices = [];
        $scope.currentAccount = BanksList.getCurrentAccount();

        $scope.disableButton = true;
        angular.forEach(BanksList.loadData(), function(BankService){
            if(BankService.symbol == 'INVESTMENT' || (BankService.symbol == 'REVOLVING_LOAN' &&  !BankService.isUsed()))
            {
                var BS = angular.copy(BankService);
                BS.types.forEach(function(BSO, index){
                    BSO.checked = false;
                    BSO.removeAllCompanyBankServices();
                    BSO.addCompanyBankService();
                });
                $scope.avaibleBankServices.push(BS);
            }
        });

        $scope.openModal();
    });

    $scope.openModal = function(){
        angular.element(elementId).modal('show');
    }

    $scope.closeModal = function(){
        angular.element(elementId).modal('hide');
    }

    $scope.checkBankService = function(BankServiceOption, BankService){
        var isChecked = BankServiceOption.checked;
        if(BankServiceOption.flags == 'O')
        {
            angular.forEach(BankService.types, function(bso){
                bso.checked = false;
            });

            if(isChecked)
            {
                BankServiceOption.checked = !BankServiceOption.checked;
            }
        }
        BankServiceOption.checked = !BankServiceOption.checked;
    }

//    $scope.increaseVal = function(type) {
//        $scope.disableButton = false;
//        type.value = Number(type.value) + 1;
//    }
//
//
//    $scope.decreaseVal = function(type) {
//        if(type.value > 1)
//        {
//            type.value = Number(type.value) - 1;
//        }
//    }

    $scope.showValidationMsg = function(title, msg) {
        var params = {};
        params.title = title;
        params.msg = msg;

        $rootScope.$broadcast('Validation:openValidationModal', params);
    }

    $scope.save = function(){
        var totalValue = 0;
        var loanValue = 0;

        $scope.avaibleBankServices.forEach(function(BankService){
            if(BankService.symbol == 'INVESTMENT')
            {
                BankService.types.forEach(function(BankServiceOption){
                    if(BankServiceOption.isChecked())
                    {
                        totalValue += parseFloat(BankServiceOption.getTotalValue());
                    }
                });
            }

            if(BankService.symbol == 'REVOLVING_LOAN')
            {
                BankService.types.forEach(function(BankServiceOption){
                    if(BankServiceOption.isChecked())
                    {
                        loanValue += parseFloat(BankServiceOption.getTotalValue());
                    }
                });
            }
        });


        if(((totalValue == 0 && $scope.currentAccount.getTotalValue() <= 0) || totalValue <= $scope.currentAccount.getTotalValue()) && loanValue <= 5000000)
        {
            $scope.avaibleBankServices.forEach(function(BankService){
                if(BankService.symbol == 'INVESTMENT')
                {
                    BankService.types.forEach(function(BankServiceOption){
                        if(BankServiceOption.isChecked() && BankServiceOption.getTotalValue())
                        {
                            var OriginalBankService = BanksList.findBankServiceBySymbol(BankService.symbol);
                            OriginalBankService.types.forEach(function(OriginalBankServiceOption){
                                if(BankServiceOption.id == OriginalBankServiceOption.id)
                                {
                                    OriginalBankServiceOption.company_bank_service_options.push(BankServiceOption.company_bank_service_options[0]);
                                    $scope.currentAccount.company_bank_service_options[0].value -= parseFloat(BankServiceOption.company_bank_service_options[0].value);
                                }
                            });
                        }
                    });
                }

                if(BankService.symbol == 'REVOLVING_LOAN')
                {
                    BankService.types.forEach(function(BankServiceOption){
                        if(BankServiceOption.isChecked() && BankServiceOption.getTotalValue())
                        {
                            var OriginalBankService = BanksList.findBankServiceBySymbol(BankService.symbol);
                            OriginalBankService.types.forEach(function(OriginalBankServiceOption){
                                if(BankServiceOption.id == OriginalBankServiceOption.id)
                                {
                                    OriginalBankServiceOption.company_bank_service_options.push(BankServiceOption.company_bank_service_options[0]);
                                    $scope.currentAccount.company_bank_service_options[0].value += parseFloat(BankServiceOption.company_bank_service_options[0].value);
                                    $scope.currentAccount.company_bank_service_options[0].value -= parseFloat(BankServiceOption.cost);
                                }
                            });
                        }
                    });
                }
            });

            $scope.closeModal();
        }
        else
        {
            if(loanValue <= 5000000)
            {
                $scope.showValidationMsg('Brak środków', 'Podana kwota przewyższa Twoje możliwości finansowe.');
            }
            else
            {
                $scope.showValidationMsg('Brak zdolności kredytowej', 'Maksymalny mozliwy kredyt obrotowy to 2 000 000 zł.');
            }
        }
    }


    $scope.isAnyElementSelected = function(){
        var isOk = false;
        if($scope.avaibleBankServices.length > 0)
        {
            $scope.avaibleBankServices.forEach(function(BankService){
                BankService.types.forEach(function(BankServiceOption){
                    if(BankServiceOption.isChecked() && BankServiceOption.getTotalValue() > 0)
                    {
                        isOk = true;
                    }
                });
            });
        }
        return isOk;
    }

}

